# packages
pacman::p_load(car, sjstats, jtools, agricolae, tidyverse, dplyr, tidyr, readxl, ggplot2)

ath = read_excel('DataSets.xlsx',
                 sheet = 'anova',
                 range = 'Q15:T123')
str(ath)
ath$Treatment = as.factor(ath$Treatment)
ath$Exercise = as.factor(ath$Exercise)
str(ath)

# two-way anova: additive
mod2 = aov(Rate ~ Treatment + Exercise, ath)
summary(mod2)

# Interactive model
modint = aov(Rate ~ Treatment + Exercise + Treatment:Exercise, ath)
summary(modint)

summary(ath$Treatment)
summary(ath$Exercise)
# interaction plot
with(ath, interaction.plot(Treatment, Exercise, Rate))

interaction.plot(ath$Treatment, ath$Exercise, ath$Rate)

# interaction is not significant, so proceed with additive model

# post hoc 
tukey = HSD.test(mod2, trt = c('Treatment', 'Exercise'))

a = tukey$mean %>% rownames_to_column("Variable")
b = tukey$groups %>% rownames_to_column("Variable")

figdata = left_join(a[c(1:4)], b[c(1,3)], by = 'Variable')
figdata

figdata = figdata %>% mutate(
  se = std/sqrt(r),
  UL = Rate + se*1.96,
  LL = Rate - se*1.96
)
figdata = figdata %>% 
  separate(Variable, sep = ":",
           into = c('Lesion', 'Exercise'))
figdata

p = position_dodge(width = 0.9)

ggplot(figdata) +
  aes(x = Lesion, y = Rate, color = Lesion, fill = Exercise) +
  geom_col(position = p) +
  geom_errorbar(aes(ymin = LL, ymax = UL), width = 0.2, color = 'black', position = p) +
  geom_text(aes(y = UL+10, label = groups), color = 'grey20', position = p)+
  theme_bw() +
  theme(legend.position = 'top')
